<?php

namespace Welford\AddressLookupApis\APIs;

use Welford\AddressLookupApis\Models\Address;

class GooglePlaces extends BaseAPI
{

    private string $api_key;

    /**
     * GooglePlaces constructor.
     * @param array $credentials
     */
    public function __construct(array $credentials = [])
    {
        if (!empty($credentials) && isset($credentials['api-key'])) {
            $this->api_key = $credentials['api-key'];
        }
    }

    protected static function getMethod(): string
    {
        return "GET";
    }

    public function performLookup($postcode, $building_number = null, $building_name = null): array
    {
        $addresses = [];
        $endpoint = "https://maps.googleapis.com/maps/api/place/autocomplete/json?input={postcode}&key=" . $this->api_key;
        $endpoint = str_replace('{postcode}', rawurlencode($postcode), $endpoint);

        $response = json_decode($this->send($endpoint), true);

        foreach ($response['predictions'] as $result) {

            if (isset($result['place_id'])) {
                $endpoint = "https://maps.googleapis.com/maps/api/place/details/json?place_id=" . $result['place_id'] . "&fields=address_component&key=" . $this->api_key;
                $details_response = json_decode($this->send($endpoint), true);
                if (is_array($details_response) && isset($details_response['result']['address_components'])) {
                    if (is_array($details_response['result']['address_components'])) {
                        $address = new Address();
                        $address->building_number = $building_number;
                        foreach ($details_response['result']['address_components'] as $component) {
                            foreach ($component['types'] as $type) {
                                switch ($type) {
                                    case "street_number":
                                        if (empty($building_number)) {
                                            $address->building_number = $component['long_name'];
                                        }
                                        break;
                                    case  "route":
                                        $address->line1 = $component['long_name'];
                                        break;
                                    case "locality":
                                        $address->line2 = $component['long_name'];
                                        break;
                                    case "postal_town":
                                        $address->town_or_city = $component['long_name'];
                                        break;
                                    case "administrative_area_level_2":
                                        $address->county_or_region = $component['long_name'];
                                        break;
                                    case "postal_code":
                                        $address->postcode = $component['long_name'];
                                        break;
                                    case "country":
                                        $address->country = $component['long_name'];
                                        break;
                                }
                            }
                        }
                        $addresses[] = $address;
                    }
                }
            }
        }

        return $addresses;
    }
}
