<?php


namespace Welford\AddressLookupApis\APIs;


use Welford\AddressLookupApis\Models\Address;

class IdealPostcodes extends BaseAPI
{

    private string $api_key;

    /**
     * IdealPostcodes constructor.
     * @param array $credentials
     */
    public function __construct(array $credentials = [])
    {
        if (!empty($credentials) && isset($credentials['api_key'])) {
            $this->api_key = $credentials['api_key'];
        }
    }

    protected static function getMethod(): string
    {
        return "GET";
    }

    public function performLookup($postcode, $building_number = null, $building_name = null): array
    {
        $addresses = [];
        $endpoint = "https://api.ideal-postcodes.co.uk/v1/postcodes/{postcode}";
        $endpoint = str_replace('{postcode}', rawurlencode($postcode), $endpoint);

        $endpoint .= '?' . http_build_query(['api_key' => $this->api_key]);

        $response = json_decode($this->send($endpoint), true);

        foreach ($response['result'] as $result) {
            if (is_array($result)) {
                $address = new Address();
                $address->building_name = $result['building_name'] ?? "";
                $address->building_number = $result['building_number'] ?? "";
                $address->thoroughfare = $result['thoroughfare'] ?? "";
                $address->line1 = $result['line_1'] ?? "";
                $address->line2 = $result['line_2'] ?? "";
                $address->line3 = $result['line_3'] ?? "";
                $address->line4 = "";
                $address->locality = $result['locality'] ?? "";
                $address->town_or_city = $result['post_town'] ?? "";
                $address->county_or_region = $result['county'] ?? "";
                $address->district = $result['district'] ?? "";
                $address->postcode = $result['postcode'] ?? "";
                $address->country = $result['country'] ?? "";
                $addresses[] = $address;
            }
        }

        return $addresses;
    }
}
