<?php

use Welford\AddressLookupApis\AddressClient;
use Welford\AddressLookupApis\Models\Address;
use PHPUnit\Framework\TestCase;

class AddressClientTest extends TestCase
{

    public function testGetAddressIO(): void
    {
        $client = new AddressClient('GetAddressIO', ['api-key' => 'au6nyFVXYECHGkNgawN8WQ41986']);
        $this->assertInstanceOf(AddressClient::class, $client);
        $response = $client->lookup('LS11 5QG');
        $this->assertIsArray($response);
        if (isset($response[0])) {
            $this->assertInstanceOf(Address::class, $response[0]);
        }
    }

    public function testIdealPostcodes(): void
    {
        $client = new AddressClient('IdealPostcodes', ['api_key' => 'ak_lt8r8pbgiyM9MYD7o1uwm5Csw0EVn']);
        $this->assertInstanceOf(AddressClient::class, $client);
        $response = $client->lookup('SW1A2AA');
        $this->assertIsArray($response);
        if (isset($response[0])) {
            $this->assertInstanceOf(Address::class, $response[0]);
        }
    }

    public function testPostcoder(): void
    {
        $client = new AddressClient('Postcoder', ['api_key' => 'PCW45-12345-12345-1234X']);
        $this->assertInstanceOf(AddressClient::class, $client);
        $response = $client->lookup('NR14 7PZ');
        $this->assertIsArray($response);
        if (isset($response[0])) {
            $this->assertInstanceOf(Address::class, $response[0]);
        }
    }

    public function testFetchify(): void
    {
        $client = new AddressClient('Fetchify', ['key' => 'xxxxx-xxxxx-xxxxx-xxxxx']);
        $this->assertInstanceOf(AddressClient::class, $client);
        $response = $client->lookup('LS11 5QG');
        $this->assertIsArray($response);
        if (isset($response[0])) {
            $this->assertInstanceOf(Address::class, $response[0]);
        }
    }

    public function testGooglePlaces()
    {
        $client = new AddressClient('GooglePlaces', ['api-key' => 'AIzaSyCGJp20_4eQhxJ-roeCBHFi3Oo7MHAZQA8']);
        $this->assertInstanceOf(AddressClient::class, $client);
        $response = $client->lookup('LS27 9PR', 9);
        $this->assertIsArray($response);
        if (isset($response[0])) {
            $this->assertInstanceOf(Address::class, $response[0]);
        }
    }
}
