<?php

namespace Welford\AddressLookupApis\APIs;

use GuzzleHttp\Exception\GuzzleException;
use Welford\AddressLookupApis\Models\Address;

class GetAddressIO extends BaseAPI
{

    private string $api_key;

    /**
     * GetAddressIO constructor.
     * @param array $credentials
     */
    public function __construct(array $credentials = [])
    {
        if (!empty($credentials) && isset($credentials['api-key'])) {
            $this->api_key = $credentials['api-key'];
        }
    }

    protected static function getMethod(): string
    {
        return "GET";
    }

    /**
     * @throws GuzzleException
     */
    public function performLookup($postcode, $building_number = null, $building_name = null): array
    {
        $addresses = [];
        $endpoint = "https://api.getAddress.io/find/{postcode}/{building}";
        $endpoint = str_replace('{postcode}', rawurlencode($postcode), $endpoint);

        if ($building_number !== null) {
            $endpoint = str_replace('{building}', rawurlencode($building_number), $endpoint);
        } else if ($building_name !== null) {
            $endpoint = str_replace('{building}', rawurlencode($building_name), $endpoint);
        } else {
            $endpoint = str_replace('/{building}', "", $endpoint);
        }

        $endpoint .= '?' . http_build_query(['api-key' => $this->api_key, 'expand' => 'true']);

        $response = json_decode($this->send($endpoint), true);

        foreach ($response['addresses'] as $result) {
            if (is_array($result)) {
                $address = new Address();
                $address->building_name = $result['building_name'] ?? "";
                $address->building_number = $result['building_number'] ?? "";
                $address->thoroughfare = $result['thoroughfare'] ?? "";
                $address->line1 = $result['line_1'] ?? "";
                $address->line2 = $result['line_2'] ?? "";
                $address->line3 = $result['line_3'] ?? "";
                $address->line4 = $result['line_4'] ?? "";
                $address->locality = $result['locality'] ?? "";
                $address->town_or_city = $result['town_or_city'] ?? "";
                $address->county_or_region = $result['county'] ?? "";
                $address->district = $result['district'] ?? "";
                $address->postcode = $postcode ?? "";
                $address->country = $result['country'] ?? "";
                $addresses[] = $address;
            }
        }

        return $addresses;
    }
}
