<?php

namespace Welford\AddressLookupApis\APIs;

use GuzzleHttp\Exception\GuzzleException;
use Welford\AddressLookupApis\Models\Address;

class Postcoder extends BaseAPI
{

    private string $api_key;

    /**
     * Postcoder constructor.
     * @param array $credentials
     */
    public function __construct(array $credentials = [])
    {
        if (!empty($credentials) && isset($credentials['api_key'])) {
            $this->api_key = $credentials['api_key'];
        }
    }

    protected static function getMethod(): string
    {
        return "GET";
    }

    /**
     * @throws GuzzleException
     */
    public function performLookup($postcode, $building_number = null, $building_name = null): array
    {
        $addresses = [];
        $endpoint = "https://ws.postcoder.com/pcw/{api_key}/address/UK/{postcode}";
        $endpoint = str_replace('{postcode}', rawurlencode($postcode), $endpoint);
        $endpoint = str_replace('{api_key}', rawurlencode($this->api_key), $endpoint);

        $endpoint .= '?' . http_build_query([
            'include' => 'county,posttown,postcode',
            'format' => 'json',
            'lines' => 4,
            'addtags' =>'country,postalcounty'
        ]);

        $response = json_decode($this->send($endpoint), true);

        foreach ($response as $result) {
            if (is_array($result)) {
                $address = new Address();
                $address->building_name = $result['buildingname'] ?? "";
                $address->building_number = $result['number'] ?? "";
                $address->thoroughfare = $result['street'] ?? "";
                $address->line1 = $result['addressline1'] ?? "";
                $address->line2 = $result['addressline2'] ?? "";
                $address->line3 = $result['addressline3'] ?? "";
                $address->line4 = $result['addressline4'] ?? "";
                $address->locality = $result['locality'] ?? "";
                $address->town_or_city = $result['posttown'] ?? "";
                $address->county_or_region = $result['county'] ?? "";
                $address->district = $result['dependentlocality'] ?? "";
                $address->postcode = $result['postcode'] ?? "";
                $address->country = $result['country'] ?? "";
                $addresses[] = $address;
            }
        }

        return $addresses;
    }
}
