<?php

namespace Welford\AddressLookupApis\APIs;

use Exception;
use Welford\AddressLookupApis\Models\Address;

class Fetchify extends BaseAPI
{

    private string $api_key;

    /**
     * Fetchify constructor.
     * @param array $credentials
     */
    public function __construct(array $credentials = [])
    {
        if (!empty($credentials) && isset($credentials['key'])) {
            $this->api_key = $credentials['key'];
        }
    }

    protected static function getMethod(): string
    {
        return "GET";
    }

    /**
     * @throws \GuzzleHttp\Exception\GuzzleException
     * @throws Exception
     */
    public function performLookup($postcode, $building_number = null, $building_name = null): array
    {
        $addresses = [];
        $endpoint = "https://pcls1.craftyclicks.co.uk/json/rapidaddress";

        $endpoint .= '?' . http_build_query(['key' => $this->api_key, 'response' => 'data_formatted', 'postcode' => $postcode]);

        $response = json_decode($this->send($endpoint), true);

        if (isset($response['delivery_points']) && is_array($response['delivery_points'])) {
            foreach ($response['delivery_points'] as $delivery_point) {
                $address = new Address();
                $address->building_name = $delivery_point['organisation_name'] ?? "";
                $address->building_number = "";
                $address->thoroughfare = "";
                $address->line1 = $delivery_point['line_1'] ?? "";
                $address->line2 = $delivery_point['line_2'] ?? "";
                $address->line3 = $delivery_point['line_3'] ?? "";
                $address->line4 = $delivery_point['line_4'] ?? "";
                $address->locality = "";
                $address->town_or_city = $response['town'];
                $address->county_or_region = $response['postal_county'];
                $address->district = $response['traditional_county'];
                $address->postcode = $response['postcode'];
                $address->country = "";
                $addresses[] = $address;
            }
        } else if (isset($response['error_code'])) {
            throw new Exception('FETCHIFY ERROR: ' . ($response['error_msg'] ?? 'No Message Provided'), $response['error_code']);
        }

        return $addresses;
    }
}
