<?php

namespace Welford\AddressLookupApis;

use Exception;

class AddressClient
{
    private $api;

    /**
     * AddressClient constructor.
     * @param string $api
     * @param array $credentials
     * @throws Exception
     */
    public function __construct(string $api, array $credentials)
    {
        $class = "\\Welford\\AddressLookupApis\\APIs\\" . $api;
        if (!class_exists($class)) {
            throw new Exception("The specified API is not included in the library.", '1');
        } else {
            $this->api = new $class($credentials);
        }
    }

    /**
     * @param $postcode
     * @param null $building_number
     * @param null $building_name
     * @return array
     */
    public function lookup($postcode, $building_number = null, $building_name = null): array
    {
        return $this->api->performLookup($postcode, $building_number, $building_name);
    }
}