<?php

namespace Welford\AddressLookupApis\APIs;

use Exception;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;
use GuzzleHttp\Exception\GuzzleException;

abstract class BaseAPI
{
    protected Client $http_client;
    public array $options = [];

    abstract protected static function getMethod(): string;
    abstract public function performLookup($postcode, $building_number = null, $building_name = null): array;

    /**
     * @throws GuzzleException
     */
    protected function send(string $endpoint = null, array $params = [], array $headers = []): string
    {
        $this->http_client = new Client();

        if (!empty($headers)) {
            $this->options = array_merge($this->options, [
                'headers' => $headers
            ]);
        }

        if (!empty($params)) {
            $this->options = array_merge($this->options, [
                'form_params' => $params
            ]);
        }

        try {
            $request = $this->http_client->createRequest(static::getMethod(), $endpoint, $this->options);
            $response = $this->http_client->send($request);
        } catch(ClientException $e) {
            throw new Exception($e->getResponse()->getBody()->getContents());
        }
        return $response->getBody()->getContents();
    }
}
