<?php

namespace Welford\AddressLookupApis\APIs;

use GuzzleHttp\Exception\GuzzleException;
use Welford\AddressLookupApis\Models\Address;

class GooglePlaces extends BaseAPI
{

    private string $api_key;

    /**
     * GooglePlaces constructor.
     * @param array $credentials
     */
    public function __construct(array $credentials = [])
    {
        if (!empty($credentials) && isset($credentials['api-key'])) {
            $this->api_key = $credentials['api-key'];
        }
    }

    protected static function getMethod(): string
    {
        return "GET";
    }

    /**
     * @throws GuzzleException
     */
    public function performLookup($postcode, $building_number = null, $building_name = null): array
    {
        $addresses = [];
        $endpoint = "https://maps.googleapis.com/maps/api/place/findplacefromtext/output?input={postcode}&inputtype=textquery&fields=address_component&key=" . $this->api_key;
        $endpoint = str_replace('{postcode}', rawurlencode($postcode), $endpoint);

        $response = json_decode($this->send($endpoint), true);

        foreach ($response['candidates'] as $result) {
            if (is_array($result) && isset($result['address_components'])) {
                if (is_array($result['address_components'])) {
                    $address = new Address();
                    foreach ($result['address_components'] as $component) {
                        switch ($component['type']) {
                            case "street_number":
                                $address->building_number = $component['long_name'];
                                break;
                            case  "street_address":
                                $address->line1 = $component['long_name'];
                                break;
                            case "postal_town":
                                $address->town_or_city = $component['long_name'];
                                break;
                            case "administrative_area_level_1":
                                $address->county_or_region = $component['long_name'];
                                break;
                            case "postal_code":
                                $address->postcode = $component['long_name'];
                                break;
                            case "country":
                                $address->country = $component['long_name'];
                                break;
                        }
                    }
                    $addresses[] = $address;
                }
            }
        }

        return $addresses;
    }
}
