<?php

namespace Welford\AddressLookupApis\APIs;

use CurlHandle;
use Exception;

abstract class BaseAPI
{
    public array $options = [];

    abstract protected static function getMethod(): string;
    abstract public function performLookup($postcode, $building_number = null, $building_name = null): array;

    /**
        @throws Exception
     */
    protected function send(string $endpoint = null, array $params = [], array $headers = []): string
    {
        if (!empty($headers)) {
            $this->options = array_merge($this->options, [
                'headers' => $headers
            ]);
        }

        if (!empty($params)) {
            $this->options = array_merge($this->options, [
                'form_params' => $params
            ]);
        }

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $endpoint);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, static::getMethod());

        switch (static::getMethod()) {
            case 'POST':
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($this->options['form_params'] ?? []));
                break;
            default:
                if (!empty($this->options['form_params'])) {
                    $endpoint = $endpoint . '?' . http_build_query($this->options['form_params']);
                }
        }

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch));
        }
        if ($httpCode >= 400 && $httpCode < 500) {
            throw new Exception("Request error: $httpCode" . " - " . $response);
        } else if ($httpCode >= 500) {
            throw new Exception("Server error: $httpCode" . " - " . $response);
        }

        curl_close($ch);

        return $response;
    }
}
