<?php

namespace Welford\HttpRateLimiter\Adapters;

use Exception;

abstract class BaseAdapter
{
    abstract public static function getCount(int $expire = 60, array $options = []): int;

    /**
     * @throws Exception
     */
    protected static function getCacheKey(): string
    {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            return self::slug('welford-rate-limiter-' . $_SERVER['HTTP_CLIENT_IP']);
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            return self::slug('welford-rate-limiter-' . $_SERVER['HTTP_X_FORWARDED_FOR']);
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED'])) {
            return self::slug('welford-rate-limiter-' . $_SERVER['HTTP_X_FORWARDED']);
        } elseif (!empty($_SERVER['HTTP_FORWARDED_FOR'])) {
            return self::slug('welford-rate-limiter-' . $_SERVER['HTTP_FORWARDED_FOR']);
        } elseif (!empty($_SERVER['HTTP_FORWARDED'])) {
            return self::slug('welford-rate-limiter-' . $_SERVER['HTTP_FORWARDED']);
        } elseif (!empty($_SERVER['REMOTE_ADDR'])) {
            return self::slug('welford-rate-limiter-' . $_SERVER['REMOTE_ADDR']);
        }
        throw new Exception('Could not determine IP address');
    }

    private static function slug($text): string
    {
        $text = preg_replace('~[^\pL\d]+~u', '-', $text);
        $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
        $text = preg_replace('~[^-\w]+~', '', $text);
        $text = trim($text, '-');
        $text = preg_replace('~-+~', '-', $text);
        $text = strtolower($text);
        if (empty($text)) {
            return 'n-a';
        }
        return $text;
    }
}
