<?php

namespace Welford\HttpRateLimiter\Adapters;

use Exception;

class File extends BaseAdapter
{

    /**
     * @throws Exception
     */
    public static function getCount(int $expire = 60, array $options = []): int
    {
        $path = $options['path'] ?? '';

        if (empty($path)) {
            throw new Exception('File path not set');
        } else if (!is_dir($path)) {
            throw new Exception("File cache directory not found or is not a directory");
        } else if (!is_writable($path)) {
            throw new Exception("File cache directory is not writable");
        }

        $key = self::getCacheKey();
        $now = time();
        $file = $path . "/" . $key . ".cache";
        if (file_exists($file)) {
            $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        } else {
            $lines = [];
        }
        $new_file = array();

        if ($lines !== false) {
            foreach ($lines as $line) {
                if ((int)$line > $now - $expire) {
                    $new_file[] = $line;
                }
            }
        }
        $new_file[] = $now;
        $count = count($new_file);
        file_put_contents($file, implode(PHP_EOL, $new_file));

        return $count;
    }
}
