<?php

namespace Welford\HttpRateLimiter\Adapters;

use Exception;
use Memcached as PhpMemcached;

class Memcached extends BaseAdapter
{

    /**
     * @throws Exception
     */
    public static function getCount(int $expire = 60, array $options = []): int
    {
        if (!extension_loaded('memcached')) {
            throw new Exception('Memcached extension not loaded');
        }
        if (empty($options['host']) || empty($options['port'])) {
            throw new Exception('Memcached host or port not set');
        }

        $memcached = new PhpMemcached();
        $memcached->addServer($options['host'], $options['port']);

        $key = self::getCacheKey();
        $record = $memcached->get($key);
        $now = time();
        if ($record === false) {
            $record = '';
        }
        $timestamps = explode(PHP_EOL, $record);
        $new_timestamps = [];
        foreach ($timestamps as $timestamp) {
            if ((int)$timestamp > $now - $expire) {
                $new_timestamps[] = $timestamp;
            }
        }
        $new_timestamps[] = $now;
        $memcached->set($key, implode(PHP_EOL, $new_timestamps), $expire);

        return count($new_timestamps);
    }
}
