<?php

namespace Welford\HttpRateLimiter\Adapters;

use Exception;
use Redis as PhpRedis;
use RedisException;

class Redis extends BaseAdapter
{
    /**
     * @throws RedisException
     * @throws Exception
     */
    public static function getCount(int $expire = 60, array $options = []): int
    {
        if (!extension_loaded('redis')) {
            throw new Exception('Redis extension not loaded');
        }
        if (empty($options['host']) || empty($options['port'])) {
            throw new Exception('Redis host or port not set');
        }

        $redis = new PhpRedis();
        $redis->connect($options['host'], $options['port']);
        if (isset($options['key'])) {
            $redis->auth($options['key']);
        }

        $key = self::getCacheKey();
        $timestamps = explode(PHP_EOL, $redis->get($key));
        $now = time();
        $new_timestamps = [];
        foreach ($timestamps as $timestamp) {
            if ((int)$timestamp > $now - $expire) {
                $new_timestamps[] = $timestamp;
            }
        }
        $new_timestamps[] = $now;
        $redis->set($key, implode(PHP_EOL, $new_timestamps));
        $redis->expire($key, $expire);

        return count($new_timestamps);
    }
}
