<?php

/*
 * IMPORTANT : PLEASE READ
 * All tests in this file should return an error displaying:
 * "Cannot modify header information - headers already sent"
 * This is because PHPUnit is not able to deal with modified headers during tests.
 * However, if this error is appearing it proves that the headers are being modified correctly
 * to include the 429 status code.
 */

namespace Welford\HttpRateLimiter\Tests;

use Exception;
use PHPUnit\Framework\TestCase;
use Welford\HttpRateLimiter\HttpRateLimiter;

class HttpRateLimiterTest extends TestCase
{
    private int $limit = 10;
    private int $expire = 60;

    protected function setUp(): void
    {
        $_SERVER['REMOTE_ADDR'] = '127.0.0.1';
    }

    /**
     * @throws Exception
     */
    public function testRedis()
    {
        $options = [
            'host' => '127.0.0.1',
            'port' => 6379,
            'key' => null
        ];
        for ($i = 0; $i < $this->limit; $i++) {
            HttpRateLimiter::check(HttpRateLimiter::REDIS, $options, $this->limit, $this->expire);
        }
        HttpRateLimiter::check(HttpRateLimiter::REDIS, $options, $this->limit, $this->expire);
    }

    /**
     * @throws Exception
     */
    public function testMemcached()
    {
        $options = [
            'host' => '127.0.0.1',
            'port' => 11211
        ];
        for ($i = 0; $i < $this->limit; $i++) {
            HttpRateLimiter::check(HttpRateLimiter::MEMCACHED, $options, $this->limit, $this->expire);
        }
        HttpRateLimiter::check(HttpRateLimiter::MEMCACHED, $options, $this->limit, $this->expire);
    }

    public function testPdoMySql()
    {
        $options = [
            'type' => 'mysql',
            'host' => '127.0.0.1',
            'port' => 3306,
            'database' => 'test',
            'username' => 'root',
            'password' => 'password',
            'table' => 'http_rate_limiter'
        ];
        for ($i = 0; $i < $this->limit; $i++) {
            HttpRateLimiter::check(HttpRateLimiter::PDO, $options, $this->limit, $this->expire);
        }
        HttpRateLimiter::check(HttpRateLimiter::PDO, $options, $this->limit, $this->expire);
    }

    public function testFile()
    {
        $options = [
            'path' => __DIR__ . '/cache'
        ];
        if (!file_exists($options['path'])) {
            mkdir($options['path']);
        }
        for ($i = 0; $i < $this->limit; $i++) {
            HttpRateLimiter::check(HttpRateLimiter::FILE, $options, $this->limit, $this->expire);
        }
        HttpRateLimiter::check(HttpRateLimiter::FILE, $options, $this->limit, $this->expire);
    }
}
