<?php

use PHPUnit\Framework\TestCase;
use Welford\Ipfs\Client;

class ClientTest extends TestCase
{
    /**
     * @throws Exception
     */
    public function testUploadDirectory()
    {
        $path = __DIR__ . DIRECTORY_SEPARATOR . 'test_upload';

        $client = new Client("192.168.1.200", "5001");
        $output = $client->addFolder($path);
        $this->assertIsArray($output);
        $this->assertArrayHasKey('hash', $output);
    }

    /**
     * @throws Exception
     */
    public function testUploadFile()
    {
        $path = __DIR__ . DIRECTORY_SEPARATOR . 'test_upload.txt';

        $client = new Client("192.168.1.200", "5001");
        $output = $client->addFile($path);
        $this->assertIsArray($output);
        $this->assertArrayHasKey('hash', $output);
    }
}
