# NHS Mesh for Laravel

> Original Author - Phill Morgan

> Current Version - 1.0.3

This library provides a mail driver for Laravel 7 or above for use with the NHS Message Exchange for Social Case and Health.

## Dependencies

- PHP 7.4 or above
- JSON PHP extension
- Mbstring PHP extension
- OpenSSL PHP extension
- Zip PHP extension
- Laravel 7 or above
- Welford NHS Mesh Library 1.0 or above
- zbateson/mail-mime-parser 2.0 or above

## Installation

Use the codebase provided repository snippet to add the Welford composer package repository to your composer.json file, then run:

```
composer require welford/nhs-mesh-laravel
```

## Usage

After installation you should define your environmental variables as follows:

```
MAIL_MAILER=nhsmesh

# 1 = PROD | 2 = DEV
MESH_ENVIRONMENT=1

MESH_HMAC_SECRET=HMAC_SECRET_FOR_ENVIRONMENT

MESH_CA_CERT="-----BEGIN CERTIFICATE-----
CERTIFICATE_CONTENT_HERE
-----END CERTIFICATE-----"

MESH_MAILBOX_CERT="-----BEGIN CERTIFICATE-----
CLIENT_CERTIFICATE_CONTENT_HERE
-----END CERTIFICATE-----"

MESH_MAILBOX_KEY="-----BEGIN RSA PRIVATE KEY-----
CLIENT_KEY_CONTENT_HERE
-----END RSA PRIVATE KEY-----"

MESH_MAILBOX_ID=YOUR_MAILBOX_ID

MESH_MAILBOX_PASSWORD=YOUR_MAILBOX_PASSWORD
```

The certificate contents will be added to temporary files during each request. You should not store your certificate files or secrets directly inside your repository.

> Once configured, Laravel will no longer send e-mail using any other driver such as SMTP. You will need to use an alternative method to dispatch standard e-mails.

To send a message you can now use the standard Mail functions as provided by Laravel.

As MESH mailboxes do not use a standard e-mail address format you should ensure your `to` addresses are formatted as "`to_mailbox_id`@`to_workflow_id`.com". This is to ensure the driver can bypass any e-mail address validation present in the Laravel mail classes.

Plain text and rendered HTML content provided to the Laravel Mail classes will be converted to `.txt` and/or `.html` files and packaged inside a zip file along with any attachments. This zip file is then dispatched using MESH.