<?php

namespace Welford\NhsMeshLaravel;

use Illuminate\Support\ServiceProvider;
use Illuminate\Mail\MailManager;

class NhsMeshMailServiceProvider extends ServiceProvider
{

    public function boot()
    {
        $this->publishes([__DIR__.'/../config/nhsmesh.php' => config_path('nhsmesh.php')]);
    }

    public function register()
    {
        $this->mergeConfigFrom(__DIR__.'/../config/nhsmesh.php', 'nhsmesh');

        $this->app->afterResolving(MailManager::class, function (MailManager $mailManager) {
            $config = $this->app['config']->get('nhsmesh', []);
            $mailManager->extend('nhsmesh', function() use ($config) {
                return new NhsMeshTransport(
                    $config['ca_cert'],
                    $config['mailbox_cert'],
                    $config['mailbox_key'],
                    $config['mailbox_id'],
                    $config['mailbox_password'],
                    (int)$config['environment'],
                    $config['hmac_secret']
                );
            });
        });

        return $this;
    }
}