# NHS Mesh for PHP

> Original Author - Phill Morgan

> Current Version - 1.0.0

This library provides a simple interface between PHP and the NHS Messaging Exchange for Social Care and Health. It uses the Guzzle HTTP library to perform all requests.

## Dependencies

- PHP 7.4 or above
- JSON PHP extension
- Guzzle 7.4 or above

## Installation

Use the codebase provided repository snippet to add the Welford composer package repository to your composer.json file, then run:

```
composer require welford/nhs-mesh
```

## Usage

To use this library you need to instantiate a new `Client` class as shown below:

```
use Welford\NhsMesh\Client;

$client = new Client(
    $fromMailboxId,             // The mailbox ID which is sending messages
    $fromMailboxPassword,       // The password for the mailbox which is sending messages
    Client::DEV,                // The environment that is in use (DEV or PROD)
    $hmacSecret,                // The environment shared HMAC secret
    $caCertificatePath,         // The full path the the CA certificate
    $clientCertificatePath,     // The full path to the client certificate
    $clientCertificateKeyPath   // The full path to the client key
);
```

## Functions

### Validate Mailbox

```
validateMailbox(
    $fromMailboxId  // The mailbox ID which is sending messages
);

NOTE: This function should be called at least once every 24 hours to comply with Spine verification requirements.
```

### Send Message

```
sendMessage(
    $toMailboxId,   // The mailbox ID receiving the message
    $toWorkflowId,  // The workflow ID receiving the message
    $filename,      // The filename being attached to the message
    $data,          // The contents of the file
    $subject        // A human readable subject for the message (optional)
;)
```

## Unit Tests

Similar to the production environment, the testing environment requires a CA certificate, as well as a client certificate and key. These should be stored in the test directory as:

 - CA Certificate: `ca.pem`
 - Client Certificate: `cert.pem`
 - Client Key: `key.pem`

 You will also need to copy the file `.env.example` to a new file called `.env` and complete all variables. The `.env` file should also be stored in the test directory.

 > **YOU MUST NOT PUSH YOUR ENV FILE OR CERTIFICATE FILES TO THE REPOSITORY**
 
 The .gitignore file should ensure that you do not accidentally push your secrets to the repo, however caution is advised and you should check before you push any changes.

 On you've configured your environment the tests can be run using:

`./vendor/bin/phpunit tests`

If all went well you should see a total of 2 tests completed without errors.