<?php

namespace Welford\NhsMesh\Requests;

use Welford\NhsMesh\Exceptions\ParameterMissingException;

abstract class BaseRequest {
    
    protected string $method;
    protected string $endpoint;
    protected array $params;
    protected array $body;
    protected array $headers;

    public function __construct(string $method, string $endpoint, array $request_params, array $params, array $body = [], array $headers = [])
    {
        $this->method = $method;
        $this->endpoint = $endpoint;
        $this->body = $body;
        $this->headers = $headers;
        foreach($request_params as $param => $required) {
            if ($required == true) {
                if (!array_key_exists($param, $params) || trim($params[$param]) === "") {
                    throw new ParameterMissingException($param . " is missing or blank");
                }
            }
        }
        $this->params = $params;
        $this->replaceEndpointUrlWithParams();
    }

    private function replaceEndpointUrlWithParams() {
        foreach($this->params as $param_key => $param) {
            $this->endpoint = str_replace("<" . $param_key . ">", $param, $this->endpoint);
        }
    }

    /**
     * Get the value of method
     */ 
    public function getMethod()
    {
        return $this->method;
    }

    /**
     * Get the value of endpoint
     */ 
    public function getEndpoint()
    {
        return $this->endpoint;
    }

    /**
     * Get the value of body
     */ 
    public function getBody()
    {
        return $this->body;
    }

    /**
     * Get the value of headers
     */ 
    public function getHeaders()
    {
        return $this->headers;
    }
}