<?php

namespace Welford\NhsMesh\Requests;

class SendMessageRequest extends BaseRequest {

    private const METHOD = "POST";
    private const ENDPOINT = "/messageexchange/<from_mailboxId>/outbox";

    private const REQUEST_PARAMS = [
        'to_mailboxId' => true,
        'to_workflowId' => true,
        'from_mailboxId' => true,
        'filename' => true,
        'subject' => false,
        'data' => true
    ];

    public function __construct(array $params)
    {
        parent::__construct(
            self::METHOD,
            self::ENDPOINT,
            self::REQUEST_PARAMS,
            $params,
            [
                $params['data']
            ],
            [
                'Mex-To' => $params['to_mailboxId'],
                'Mex-WorkflowID' => $params['to_workflowId'],
                'Mex-FileName' => $params['filename'],
                'Mex-Subject' => $params['subject'] ?? "No subject",
                'Mex-MessageType' => "DATA",
                'Mex-Localid' => uniqid()
            ]
        );
    }
}