<?php

namespace Welford\NhsMesh\Responses;

use Exception;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;
use GuzzleHttp\Exception\ServerException;
use Welford\NhsMesh\Exceptions\InvalidRequestException;
use Welford\NhsMesh\Exceptions\SpineInternalException;

class BaseResponse {

    private $request;
    private Client $client;
    
    public int $response_code;
    public array $response_array;

    public function __construct($request, Client $client)
    {
        $this->request = $request;
        $this->client = $client;
        $this->callApi();
    }

    private function callApi() {
        $options = [];

        if (!empty($this->request->getHeaders())) {
            $options['headers'] = $this->request->getHeaders();
        }
        
        if ($this->request->getMethod() == "POST") {
            $options['body'] = json_encode($this->request->getBody());    
        }


        try {
            $response = $this->client->request($this->request->getMethod(), $this->request->getEndpoint(), $options);
        } catch (ClientException $e) {
            // Convert Guzzle exceptions to internal exceptions
            throw new InvalidRequestException($e->getResponse()->getBody()->getContents(), $e->getResponse()->getStatusCode(), $e);
        } catch (ServerException $e) {
            // Convert Guzzle exceptions to internal exceptions
            throw new SpineInternalException("Internal server error", $e->getResponse()->getStatusCode(), $e);
        }

        $this->response_code = $response->getStatusCode();
        $this->response_array = json_decode($response->getBody()->getContents(), true);
    }

}