<?php

use PHPUnit\Framework\TestCase;
use Welford\NhsMesh\Client;
use Dotenv\Dotenv;

final class ClientTest extends TestCase {
        
    private $ca = __DIR__ . "/ca.pem";
    private $client_cert = __DIR__ . "/cert.pem";
    private $client_key = __DIR__ . "/key.pem";

    private Client $client;

    protected function setUp(): void
    {
        $dotenv = Dotenv::createImmutable(__DIR__);
        $dotenv->safeLoad();

        $this->client = new Client(
            $_ENV['FROM_MAILBOX'],
            $_ENV['FROM_MAILBOX_PASSWORD'],
            Client::DEV,
            $_ENV['HMAC_SECRET'],
            $this->ca,
            $this->client_key,
            $this->client_cert
        );
    }

    public function testValidateMailbox()
    {
        $response = $this->client->validateMailbox($_ENV['FROM_MAILBOX']);
        
        $this->assertInstanceOf('Welford\NhsMesh\Responses\ValidateMailboxResponse', $response);
        $this->assertEquals(200, $response->response_code, "Response code was not 200");
        $this->assertIsArray($response->response_array, "Response array was not an array");
        $this->assertArrayHasKey('mailboxId', $response->response_array, "Response array did not contain a mailboxId");
        $this->assertEquals($_ENV['FROM_MAILBOX'], $response->response_array['mailboxId'], "Response does not contain the correct mailboxId");
    }

    public function testSendMessage()
    {
        $response = $this->client->sendMessage(
            $_ENV['TO_MAILBOX'],
            $_ENV['WORKFLOW_ID'],
            'test.txt',
            'this is a test file',
            'Test Message'
        );

        $this->assertInstanceOf('Welford\NhsMesh\Responses\SendMessageResponse', $response);
        $this->assertEquals(200, $response->response_code, "Response code was not 200");
        $this->assertIsArray($response->response_array, "Response array was not an array");
        $this->assertArrayHasKey('messageID', $response->response_array, "Response did not contain a messageID");
        $this->assertGreaterThan(0, strlen($response->response_array['messageID']), "Response does not contain a valid messageId");
    }

}