# Simple CSV

The simple CSV library provides an interface to simplify and enhance CSV operations.

## Dependencies

### All Versions

- PHP 7.4 or above

## Installation

Use the codebase provided repository snippet to add the Welford composer package repository to your composer.json file,
then run:

```
composer require welford/simple-csv
```

## Features

- Read CSV in one line
- Write CSV in one line
- Add row using either associative or indexed array
- Replace row by index using either associative or indexed array
- Delete row by index
- Set cell values individually by index
- Set cell values individually by header
- Search entire CSV
- Search CSV by specific columns
- Search customisation including case sensitivity and exact matching
- Create CSV from PDO query result
- Create CSV from OpenCart query result
- Automatic row padding for null/empty columns

## Usage

Basic Example:

```
$csv = SimpleCsv::read($filename);
$csv->addRow(['something' , 'clever ', 'here'];
SimpleCsv::write($filename, $csv);
```

OpenCart Example:

```
$csv = new CsvFile();
$csv->createFromOpenCartQuery($result);
SimpleCsv::write($filename, $csv);
```

Search Example:

```
// Get a CSV
$csv = SimpleCsv::read($filename);

// Search the CSV and get an array of matched rows
$results = $csv->search($value);

// Output results to a new CSV
$newCsv = new Csv();
$newCsv->setRows($results);
SimpleCsv::write($newFilename, $newCsv);
```

Please review the unit test file for more examples.
