<?php

namespace Welford\SimpleCsv;

class SimpleCsv
{

    /**
     * @throws \Exception
     */
    public static function read(string $filename, bool $hasHeaders = false, string $delimiter = ",", string $stringEnclosure = '"'): CsvFile
    {
        $handle = fopen($filename, 'r');
        $csv = new CsvFile();
        $rows = [];
        while (($data = fgetcsv($handle, 0, $delimiter, $stringEnclosure)) !== FALSE) {
            if (!$csv->hasHeaders() && $hasHeaders) {
                $csv->setHeaders($data);
            } else {
                $rows[] = $data;
            }
        }
        $csv->setRows($rows);
        fclose($handle);

        return $csv;
    }

    public static function write(string $filename, CsvFile $csv, string $delimiter = ",", string $stringEnclosure = '"')
    {
        $handle = fopen($filename, 'w');
        if ($csv->hasHeaders()) {
            fputcsv($handle, $csv->getHeaders(), $delimiter, $stringEnclosure);
        }
        foreach ($csv->getRows() as $row) {
            fputcsv($handle, $row, $delimiter, $stringEnclosure);
        }
        fclose($handle);
    }
}
