# Welford Captcha

The Welford captcha library provides a simple interface to generate cryptographically secure random captcha images.

## Versions
> Version 1.* - provides image captcha only

> Version 2.* - provides image captcha with Google TTS API support for accessibility

## Dependencies

### All Versions
- PHP 7.4 or above
- GD PHP extension

### Version 2 Additional Dependencies
- google/cloud-text-to-speech 1.3 or above

**Version 2 also requires a Google Cloud account with the Google TTS API enabled, and a valid Google Cloud service account key file.**

## Installation

Use the codebase provided repository snippet to add the Welford composer package repository to your composer.json file, then run:

### Version 1
```
composer require welford/welford-captcha "~1.*"
```

### Version 2
```
composer require welford/welford-captcha "~2.*"
```

## Usage

Example:

```
// Create a new instance of the provider
$provider = new Provider();

// Returns the raw captcha string to be used for validation
$captchaString = $provider->getCaptchaString();

// Returns GdImage or resource containing the rendered image
$captchaImage = $provider->getCaptchaImage();
```

The library provides several customisations for the image output. Some recommended defaults have already been defined.

### Version 2 TTS Configuration

To make use of Google's TTS API you must provide a JSON configuration path to the Provider constructor. For example:

```
// Create a new instance of the provider
$provider = new Provider("abcdef...", $fullPathToMyJsonFile);
```

You can then use the builtin functions to get the audio data. All audio is provided in MP3 format, and a simple helper function is provided which will return an audio HTML tag to play the audio.

```
// Get an audio HTML example with the audio data built it
$audio = $provider->getCaptchaAudioHtml();

// Get the base64 encoded audio data for use in your own audio play back mechanism
$audio = $provider->getCaptchaAudio();
```
