<?php declare(strict_types=1);

use PHPUnit\Framework\TestCase;
use Welford\Captcha\Provider;

final class ProviderTest extends TestCase {

    public function testClassCreates() {
        $class = new Provider();
        $this->assertInstanceOf('Welford\Captcha\Provider', $class);
    }

    public function testClassCreatesCaptcha() {
        $class = new Provider();
        $string = $class->getCaptchaString();
        $this->assertIsString($string);
        $this->assertEquals(6, strlen($string));
    }

    public function testClassCreatesImage() {
        $class = new Provider();
        $image = $class->getCaptchaImage();
        if (version_compare(PHP_VERSION, '8.0.0') >= 0) {
            $this->assertInstanceOf('GdImage', $image);
        } else {
            $this->assertIsResource($image);
        }
        imagepng($image, __DIR__ . '/test_image.png');
    }

    public function testClassCreatesCustomSizeImage() {
        $class = new Provider(null, 6, 300, 100, 42);
        $image = $class->getCaptchaImage();
        if (version_compare(PHP_VERSION, '8.0.0') >= 0) {
            $this->assertInstanceOf('GdImage', $image);
        } else {
            $this->assertIsResource($image);
        }
        imagepng($image, __DIR__ . '/test_custom_image.png');
    }

}
